#============================================================================== 
# ** Classes.Random                                               By: Trickster
#------------------------------------------------------------------------------
#  A Random class for generating objects
#==============================================================================

MACL::Loaded << 'Classes.Random'

#==============================================================================
# ** Random
#==============================================================================

class Random
  #-------------------------------------------------------------------------
  # * Name      : Initialize
  #   Info      : Object Initialization
  #   Author    : Trickster
  #   Call Info : Variable Amount
  #               If a Range every object within the Range is added
  #               If a Numeric adds that object is added
  #               If a String then that string is added
  #               If an Array then all values within the array are added
  #-------------------------------------------------------------------------
  def initialize(*args)
    # Setup Data
    @data = []
    # Push Arguments to List
    push(*args)
  end
  #-------------------------------------------------------------------------
  # * Name      : Generate
  #   Info      : Generates an Object
  #               returns An Object if number is 1 and Array of Objects if 
  #               number is > 1
  #   Author    : Trickster
  #   Call Info : Zero to One
  #               Integer number Number of objects to generate (Defaults to 1)
  #-------------------------------------------------------------------------
  def generate(number = 1)
    # Create Array
    random = []
    # If Number is greater than 1
    if number > 1
      # Push Object Number Times
      number.times {random << @data[rand(@data.size)]}
      # Return Random Objects
      return random
    else
      # Retunr Random Object
      return @data[rand(@data.size)]
    end
  end
  #-------------------------------------------------------------------------
  # * Name      : Generate!
  #   Info      : Generates and Deletes Object
  #               returns An Object if number is 1 and Array of Objects if 
  #               number is > 1
  #   Author    : Trickster
  #   Call Info : Zero to One
  #               Integer number Number of objects to generate (Defaults to 1)
  #-------------------------------------------------------------------------
  def generate!(number = 1)
    # Create Array
    random = []
    # If Number is greater than 1
    if number > 1
      # Run Through Number times
      number.times {random << @data.delete_at(rand(@data.size)) if !empty?}
      # Return Array of Random
      return random
    else
      # Return Random Object And Delete
      return @data.delete_at(rand(@data.size))
    end
  end
  #-------------------------------------------------------------------------
  # * Name      : Push
  #   Info      : Push Objects to be generated
  #   Author    : Trickster
  #   Call Info : Variable Amount
  #               If a Range every object within the Range is added
  #               If a Numeric adds that object is added
  #               If a String then that string is added
  #               If an Array then all values within the array are added
  #-------------------------------------------------------------------------
  def push(*args)
    # Run Through Arguments Sent
    args.each do |argument|
      # Branch By Arguments Class
      case argument
      when Range
        # Add All Values of Range
        @data += argument.to_a
      when Hash
        # Add All Key Value Pairs Of Hash
        @data += argument.to_a
      when Array
        # Add Array
        @data += argument
      else
        # Push Argument
        @data << argument
      end
    end
  end
  #-------------------------------------------------------------------------
  # * Name      : Empty?
  #   Info      : Generator Empty? returns true if Data is empty false otherwise
  #   Author    : Trickster
  #   Call Info : No Arguments
  #-------------------------------------------------------------------------
  def empty?
    return @data.empty?
  end
  #--------------------------------------------------------------------------
  # * All Other Array methods
  #--------------------------------------------------------------------------
  def method_missing(symbol, *args)
    @data.method(symbol).call(*args)
  end
end